libname q 'c:\SASCodeforBook\SASDataSets';
Data first; set q.houstonschools;
/*This program estimates three models: Baseline Only;  Baseline + GPropensity3
+ Success for All; and Full predictor set.  The results appear in Figure 12.1
 and in Figure 12.2 The propensity scores GPropensity3 appear in the dataset houstonschools*/

			
*this code transforms the school quality rating;
SQR = .;
If schoolQR = 2 then SQR = 0;
If schoolQR = 3 then SQR = 1;
if schoolQR = 4 then SQR = 2;

*This code creats the number of positive events for each school in a year;
*There is no need to use these events and trials;
RNumPositive = round(TotalSTudents*Reading/100);
WNumPositive = round(TotalStudents*G4Write/100);
MNumPositive = round(TotalStudents*Math/100);
RMNumPositive= round(TotalStudents*AveMard/100);

*Purpose: this code changes the reference category for indicator variables;

NYRCLASS = .;
IF YRCLASS = 1 THEN NYRCLASS = 0;
IF YRCLASS = 2 THEN NYRCLASS = 1;
IF YRCLASS = 3 THEN NyrcLASS = 2;

*This code creates easier to interpret variable names;
period = nyrclass; *because of the class variable convention period = 2 is base period;
treatment = pbldum;
stratiodep= stratio;

/*This code creates implementation scores.  The analysis does not use these scores*/

Impscore = 1;
if school = 'Browning' and yrclass = 2 then Impscore = 1.494;
if school = 'Browning' and yrclass = 3 then Impscore = 1.426;
If school = 'Crockett' and yrclass = 2 then Impscore = 1.418;
If school = 'Crockett' and yrclass = 3 then Impscore = 1.369;
If school = 'Helms' and yrclass = 2 then Impscore = 1.392;
If school = 'Helms' and yrclass = 3 then Impscore = 1.370;
If school = 'Love' and yrclass = 2 then Impscore = 1.354;
If school = 'Love' and yrclass = 3 then Impscore = 1.477;
If school = 'Milam' and yrclass = 2 then Impscore = 1.456;
If school = 'Milam' and yrclass = 3 then Impscore = 1.583;
If school = 'Stevenson' and yrclass = 2 then Impscore = 1.423;
If school = 'Stevenson' and yrclass = 3 then Impscore = 1.423;

	/*This code standardizes the covariates to mean zero*/

        Proc standard data = first out= standard mean=0;
        var sfal gpropensity3
		femprob maleprob blackprob hispprob frrdprob stratio lep mobility; 
		
Title 'The variables standardized by their means';
        proc means data = standard;
        var SFAL gpropensity3
		femprob maleprob blackprob hispprob frrdprob stratio lep mobility; 
run;

data standard; set standard;

	/*This code is for the reading tests displayed in Figures 9.1 and 9.2*/
		
Title 'Reading, Proc Glimmix CS Sept. 2010  base only';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model reading/denom = treatment period treatment*period  
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = cs s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
Title2 'Difference in differences estimator for first two time periods';
*for the target group this estimates the difference between the means;
estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;   
*for the comparison group this estimates the difference between the means;
estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
*this estimates the difference between the differences;
estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
run;


/* A note on interpretation of effects.The class statement changes the reference category
of the effects by using the highest coded value of an indicator variable as the base for
the comparisons as follows:
			treatment		period		estimate
				0			  0			 .5061	
				0			  1			-.7404         	
				0			  2			     0
				1			  0              0
				1             1              0
				1			  2              0	  	


From the solutions for Fixed Effects the treatment*period interaction in condition 
treatment = 0 (comparison group) and period = 0 equals .5061. Thus, at baseline the 
comparison group's reading score is .5061 higher that at Time 2.  At Time 1 it is -.7404 lower
that at Time 2. The estimate of the comparison group treatment on the logit scale from Time 0
to Time 1 is -.7404 - (-.5061) = -1.2465. Achievement declined. This implies that the effect 
of the Conect treatment is +1.2465, the opposite, as reported in Figure 12.1.
 

This effect is also calculated from the lsestimate statement for treatment*period.  From
the computer output we have these lsestimates on the logit scale:

		Treatment	Period 	Estimate	Code  Estimate x Code
			0			0	2.0738		1			2.0738
			0			1	1.3863	   -1	       -1.3863
			0			2	2.2541		0	        0.0000
			1			0	2.3855	   -1	       -2.3855
			1			1	2.9444		1	        2.9444
			1			2	3.0718		0           0.0000
                                                Sum	1.2464

The Conect effect is defined by this comparison:  Treatment*Period (1,1 -1,0) versus (0,1 - 0,0)
This statement in effect ignores the means for period = 2.  The first parenthesis says take
the estimate for (treatment =1, period 1) = 2.9444 and subtract from it the estimate for 
(treatment = 1,period = 0 = 2.3855, this difference equals = + .5589.  Compare this change with 
that for (0,1 - 0.0), which equals 1.3863 -2.0738 = - .6875.  Now the difference between these 
difference is +.5589 - (-0.6875) =  1.2464.  On the logit scale this is the Conect effect
from the first to the second year of the evaluation. Alternatively, multiply the effect estimates
by the values of the Code and obtain 1.2464. EXP(1.2464) = 3.4778. 

	The exponentiated value for the treatment group difference is exp (.5589)= 1.74875; 
that for the comparison group is exp (-.6875)= .5028. The ratio of these exponentiated values 
= 1.74875/.5028 = 3.478. This means that the Conect schools were about 3.5 (to 1) more likely than the comparison schools to show improvement
from Time zero to Time one. For further explication see the text. */

 Title 'Reading, Proc Glimmix CS December 2010 Base + SFAL and Propensity Scores';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model reading/denom = treatment period treatment*period  sfal Gpropensity3
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =1000;
random period / sub = school(treatment)  type = cs s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
run;	

Title 'Reading, Proc Glimmix CS December 2010 Base + SFAL and Propensity Scores and Predictors';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model reading/denom = treatment period treatment*period  sfal Gpropensity3
	higraddm frrdprob stratio mobility Hispprob
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =1000;
random period / sub = school(treatment)  type = cs s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
run;	

	/*This code is for Fourth Grade Writing Tests in Figures 9.1 and 9.2*/

Title 'Grade 4 Writing in Proc Glimmix UN(1) December 2010 Base only and Propensity Scores';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model G4Write/denom = treatment period treatment*period  
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = cs s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
run;

Title 'Grade 4 Writing in Proc Glimmix UN(1) December 2010 Base + SFAL and Propensity Scores';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model G4Write/denom = treatment period treatment*period  sfal Gpropensity3
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = CS s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
run;	

Title 'Grade 4 Writing in Proc Glimmix CS December 2010 Base + SFAL and Propensity Scores and Predictors';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model G4Write/denom = treatment period treatment*period sfal Gpropensity3
	higraddm frrdprob stratio mobility Hispprob
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = CS s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
run;	

		/*This Code is for Mathematics in Figures 12.1 and 12.2*/

		
Title 'Mathematics in Proc Glimmix Toep(2) December 2010  base only';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model Math/denom = treatment period treatment*period  
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = Toep(2) s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;


Title 'Mathematics in Proc Glimmix Toep(2) December 2010 Base + SFAL and Propensity Scores';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model Math/denom = treatment period treatment*period  sfal Gpropensity3
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =1000;
random period / sub = school(treatment)  type = Toep(2) s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
run;	

Title 'Mathematics in Proc Glimmix Toep(2) December 2010 Base + SFAL and Propensity Scores and Predictors';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model Math/denom = treatment period treatment*period  sfal Gpropensity3
	higraddm frrdprob stratio mobility Hispprob
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =1000;
random period / sub = school(treatment)  type = Toep(2) s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
run;	

	/*The code is for the average of math and reading for Figures 9.1 and 9.2*/

Title 'Average Mathematics and Reading in Proc Glimmix CS December 2010  base only';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model avemard/denom = treatment period treatment*period  
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = cs s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;


Title 'Average Mathematics and Reading in Proc Glimmix CS December 2010 Base + SFAL and Propensity Scores';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model avemard/denom = treatment period treatment*period  sfal Gpropensity3
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =1000;
random period / sub = school(treatment)  type = cs s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
run;	

Title 'Average Mathematics and Reading in Proc Glimmix CS December 2010 Base + SFAL and Propensity Scores and Predictors';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
Class school treatment period; 
Model avemard/denom = treatment period treatment*period  sfal Gpropensity3
	higraddm frrdprob stratio mobility Hispprob
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =1000;
random period / sub = school(treatment)  type = cs s residual vcorr;
lsmeans  treatment*period / or ilink cl ;
lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
run;	


			/* The code for Figures 12.1 and 12.2 is now completed*/
			/* The syntax in this file is copyright by Robert B. Smith,  2011 */













































